# Ökohaus Rössing - Entwicklungs-Dokumentation

## Build-Checks

**WICHTIG:** Der Build muss IMMER vor dem Commit überprüft werden!

### Vor jedem Commit ausführen:
```bash
npm run build
```

Der Build überprüft automatisch:
- Broken Links
- TypeScript-Fehler
- Docusaurus-Konfiguration
- Markdown-Syntax

**Zusätzlich generiert der Build automatisch:**
- Quellcode-ZIP mit Commit-Hash und Datum (z.B. `oekohaus-quellcode-2025-09-22-88eb842.zip`)
- Footer-Update mit korrektem Link zur ZIP-Datei

Falls der Build fehlschlägt, müssen alle Fehler behoben werden bevor committet wird.

## Changelog

**WICHTIG:** Das Changelog muss manuell gepflegt werden.

**Changelog-Datei:** `src/pages/changelog.md`

### Changelog-Regeln für Claude
- **NUR FÜR BESUCHER RELEVANTE ÄNDERUNGEN** ins Changelog eintragen
- **NICHT eintragen:** Build-Scripte, CLAUDE.md, Entwickler-Tools, interne Konfiguration
- **EINTRAGEN:** Neue Seiten, Inhaltsänderungen, Features für Besucher, Layout-Updates
- **IMMER** das Changelog in `src/pages/changelog.md` aktualisieren wenn besucherrelevante Änderungen gemacht werden
- Neuen Eintrag mit aktuellem Datum hinzufügen (Format: ## DD.MM.YYYY)
- Deutsche Beschreibungen verwenden
- Format: [Keep a Changelog](https://keepachangelog.com/de/1.0.0/) befolgen
- Kategorien verwenden: Hinzugefügt, Geändert, Veraltet, Entfernt, Repariert, Sicherheit

### Code-Qualität

- **Biome**: Automatisches Linting und Formatierung
- **Lefthook**: Pre-commit Hooks für Code-Qualität
- **Konfiguration**: Tabs, doppelte Anführungszeichen, 80 Zeichen Zeilenlänge

### Beispiele für gute Changeset-Beschreibungen

**Patch (Fehlerbehebungen):**
- "Tippfehler in Architekturbeschreibung korrigiert"
- "Broken Link zu Partnerfirma repariert"
- "Bildgrößen für bessere Ladezeiten optimiert"

**Minor (Neue Features):**
- "Neue Seite mit Kostenaufstellung hinzugefügt"
- "Fotogalerie für Baufortschritt implementiert"
- "Newsletter-Anmeldung eingerichtet"

### Automatische Formatierung

Beim Commit werden automatisch ausgeführt:
- Biome Check & Fix für alle JS/TS/JSON Dateien
- Code-Formatierung nach Projekt-Standards
- Linting-Regeln Überprüfung

## Pull Requests

**WICHTIG:** Beim Erstellen von Pull Requests immer die richtigen GitHub-Keywords verwenden!

### PR-Beschreibung Regeln
- **IMMER** `Fix #[ISSUENUMBER]` verwenden, um Issues zu verknüpfen
- **NIEMALS** `Schließt #[ISSUENUMBER]` oder andere deutsche Keywords verwenden
- GitHub erkennt nur englische Keywords wie `Fix`, `Fixes`, `Close`, `Closes`, `Resolve`, `Resolves`

### Beispiel für gute PR-Beschreibung:
```
Fix #31

Diese PR aktualisiert die CLAUDE.md mit den richtigen Keyword-Regeln.

🤖 Generated with [Claude Code](https://claude.com/claude-code)
```