---
sidebar_label: Lasttragend
---

# Lasttragender Strohballenbau

Ich möchte hier festhalten und auch teilen, warum wir nicht lasttragend mit
Strohballen bauen, obwohl wir das lange vorhatten. Wir haben uns in der
Leistungsphase 3 entschieden, den Ansatz zu verwerfen.

## Hintergrund und Vorgeschichte

Nachdem wir entschieden hatten, dass wir mit nachwachsenden Rohstoffen bauen
möchten, sind wir zunächst auf die Baumethode der Holzständerbauweise mit
Strohdämmung und Lehmputz gekommen. Wir konnten uns einige von unserem ehemaligen Architekten gebaute
Häuser ansehen und uns von der Qualität und dem sehr hohen Wohnkomfort
überzeugen. In unseren Recherchen zu dem Thema und auch in Gesprächen mit unserem ehemaligen Architekten kamen wir dann auf das zurzeit noch sehr neue Thema des lasttragenden
Strohballenbaus mit Jumboballen. Für uns klang das Versprechen mit noch weniger
Umweltbelastung bauen zu können sehr verlockend und wir haben entsprechend einen
solchen Bau geplant und auch weiter dazu recherchiert.

## Erwartungen

Wir haben uns vom lasttragenden Strohballenbau gegenüber der Holzständerbauweise
folgende Dinge versprochen:

- Wir belasten die Umwelt weniger.
- Wir sparen Geld oder die Kosten sind zumindest gleich.
- Das Haus wird durch weniger verschiedene Bauteile einfacher in der
  Konstruktion.
- Wir demonstrieren, dass man so günstig bauen kann um möglichst viele andere
  Menschen zu solch einer Bauweise zu inspirieren.
- Wir senken den Energieverbrauch weiter ab.

## Besuche in Weimar und Erbsen

Wir hatten die großartige Gelegenheit, zwei bereits errichtete Häuser mit
lasttragender Strohballenbauweise zu besichtigen und mit den Architekt:innen zu
sprechen.

### Weimar

In Weimar haben Sarah und Florian Hoppe ein
[Doppelhaus](https://architekten-thueringen.de/aft/projekte/p/stroh_zu_gold___lastabtragendes_-4500.html)
mit lasttragenden Strohballen gebaut. Das Haus hat in drei Himmelsrichtungen
sehr starke Wände (140cm) und nach Süden sehr großzügige Öffnungen mit Fenstern.
Das Haus ist sehr schön und das Wohnklima im Haus hervorragend, aber unserer
Ansicht nach vergleichbar mit den Häusern mit Holzständerbauweise und
Strohdämmung, die wir besucht haben.

Die Hoppes sind beide Architekt:innen und Florian Hoppe forscht an der Uni in
Weimar. Er ist von der Technik begeistert und in unseren Augen ein echter
Innovator. Dabei ist er aber auch ein kompromissloser Visionär. So hat seine
Wohnung über zwei Etagen zum Beispiel keine Innentreppe zwischen den
Stockwerken: Wer nachts noch einmal in die Küche will, muss über die
Außentreppe.

Auch hat er sicher viel der notwendigen Mehrarbeit durch den Strohballenbau in
Eigenleistung gebracht und das Architekturbüro seiner Frau "Z·Architektur GbR"
tatkräftig unterstützt, was uns nicht möglich ist.

Bezüglich der Heizung verbraucht die Familie Hoppe nach eigenen Angaben
erhebliche Mengen an Brennholz. Die mancherorts angepriesene "Heizung durch die
menschliche Körperwärme" reicht offensichtlich bei weitem nicht aus.
Überschlagen habe ich einen Primärenergiebedarf von knapp unter 40 kWh/(m²·a),
was gerade einmal einem KfW-Effizienzhaus 55 entspricht. Vom Passivhaus ist dies
Welten entfernt.

### Erbsen

In Erbsen wurde ein
[Dorfgemeinschaftshaus](https://www.ndr.de/nachrichten/niedersachsen/braunschweig_harz_goettingen/Dorf-baut-sich-ein-Gemeinschaftshaus-aus-Strohballen-wie-das-geht,strohballenhaus154.html)
mit lasttragenden Strohballen errichtet. Das Dorfgemeinschaftshaus ist schön
geworden. In den Gesprächen einer der Architektinnen, Frau Heike Bröll, sind uns
einige Dinge in Erinnerung geblieben.

Die Besorgung der Strohballen war umständlich, schwierig und teuer. Durch die
Wetterlage im Jahr 2023 konnte kein adäquates Stroh geerntet werden. Der Bau hat
sich also erheblich bis zur nächsten Erntesaison verzögert. Das korrekte Pressen
der Ballen war mit erheblichem Arbeitsaufwand, auch der Architektin und anderer,
für diese Arbeiten eigentlich überqualifizierter Leute, verbunden. Die
Ausschussrate war hoch. Für den Landwirt waren die Arbeiten am Ende
wirtschaftlich äußerst unattraktiv, weil mit zu viel Zeitaufwand verbunden.

Weil wenige Spezialisten mit den Strohballen umgehen konnten und weil es auch
sehr wenige Angebote auf die Ausschreibungen gab (was wahrscheinlich an den
großen Unwägbarkeiten des Projekts lag), mussten viele Teile der Holz- und
Dachkonstruktion über weite Strecken transportiert werden. Ob dabei dann noch
die möglich CO₂-Einsparungen durch die Verwendung von Stroh gegenüber Holz die
Transportemissionen überwiegen, ist nicht bekannt.

Die Strohballen konnten nur sehr kompliziert in das Gesamtgefüge des Hauses
eingebettet werden. So steht über dem Fundament zunächst ein Betonsockel, auf
dem eine Auskragung durch eine Holzkonstruktion steht. Darauf liegen die
Strohballen, welche alle mit langen Gewindestangen an den Betonsockel gepresst
werden. Auf den Strohballen liegt oben ein Ringanker aus Holz, welcher besonders
konzipiert werden musste. Darüber kommt ein weitgehend normales Dach.

Die Setzung der Strohballen wurde viel zu hoch kalkuliert. Es wurde mit 15cm
gerechnet, am Ende waren es nach der Kombination von Vorspannen der
Gewindestangen und Auflage der Dachkonstruktion keine 5cm. Die Setzung ist, auf
Grund der unvorhersehbaren Dichte des Strohs, im Grunde unberechenbar.

Ernüchternd waren die Details zu den Kosten des Bauprojekts: Weit entfernt von
den versprochenen Einsparungen durch die Bauweise mit lasttragenden Strohballen,
lagen die tatsächlichen Kosten weit über der Kostenschätzung. Die Kosten haben
sich von geschätzt 615.000 Euro auf 800.000 Euro erhöht. Dies lag nach Angaben
von Frau Bröll vor allem an der hohen Komplexität der Zimmererarbeiten und dem
äußerst aufwendigen Genehmigungsverfahren.

## Fazit

Nach den Besuchen und unseren Recherchen kommen wir leider zu dem Ergebnis, dass
sich unsere Erwartungen nicht erfüllen werden.

- Der Energieverbrauch ist trotz der Bauweise ähnlich hoch wie mit Holzständern,
  wahrscheinlich wegen der großen Fensterflächen.
- Die Bauweise ist extrem komplex. Die oder der Statiker muss sich tief in die
  Materie einarbeiten. Sonderwünsche werden mit großer Skepsis beäugt und müssen
  oft verworfen werden (in unserem Fall war der Luftraum mit späterer
  Möglichkeit der Wohneinheitstrennung sehr kritisch). Der Hausbau gleicht
  gefühlt einer ingenieurtechnischen Promotion.
- Die Bauweise ist mit erheblichen Mehrkosten verbunden: Es müssen Prüfstatik
  und Einzelfallgenehmigung beauftragt, betrieben und bezahlt werden. Auf die
  komplexen, neuartigen Gewerke im Holzbau gibt es nur wenige und teure Gebote,
  was wahrscheinlich die hohen Unwägbarkeiten für die Zimmerleute einpreist.
- Holz ist eine Massenware, die überall und zu gleichen Qualitäten zu haben ist.
  Lasttragende Strohballen sind von schwankender Qualität und schwer zu
  bekommen. Oftmals muss man weite Transportstrecken in Kauf nehmen. Ob die
  Klimabilanz positiv ausfällt, ist zumindest fragwürdig.
- Die Bauweise taugt in keinster Weise für "die Masse". Es wird sehr viel
  Fläche - man muss es leider so sagen - verschwendet, weil die Wände so dick
  sind. Grund und Boden ist teuer und im innerstädtischen Bereich auch noch
  knapp. Diese Art des Bauens ist sicherlich kein Modell für die breite Masse,
  sondern für extravagante Häuser in Einzelstellung auf dem Land. Das ist aber
  nicht das, was wir wollen: Wir wollen ein einfaches, günstiges Haus, welches
  durch eine geringe Komplexität und wenig technischen Aufwand die Kosten
  niedrig und die Robustheit hoch hält.

Dazu kommen noch weitere Beobachtungen und Gedanken:

- Die Wände der Häuser sind extrem stark (140cm). Das liegt aber nicht daran,
  dass eine Stärke von 100cm nicht ausreichend für die Lastabtragung wäre,
  sondern vielmehr daran, dass Jumbo-Strohballen nicht in anderen Stärken zu
  bekommen sind. Hier unterwirft man sich einem Industriestandard und verzichtet
  dabei auf Wohnkomfort (schmale Leibungen). Für uns ein fragwürdiger Ansatz.
  Außerdem verwendet man ja auch deutlich zu viel Material.[^1]
- Die schwankenden Eigenschaften der Strohballen bezüglich Dichte und
  Komprimierung machen eine Vorausberechnung der Setzung mehr oder weniger
  unmöglich oder wenigstens sehr aufwendig und teuer. Auf manche konstruktiven,
  aber architektonisch ansprechenden Details muss man schon deswegen verzichten.
- Selbst im konventionellen Hausbau liegen die Emissionen
  [bei maximal 0,8t CO₂ₑ/m²](https://www.dgnb.de/de/dgnb-richtig-nutzen/newsroom/presse/artikel/dgnb-veroeffentlicht-studie-zu-co2-emissionen-von-bauwerken).
  Für unser Haus mit ca 180m² wären das nicht mehr als 144t CO₂ₑ, selbst wenn
  wir mit Beton bauen würden! Diese Emissionen durch die
  [Vernichtung von ETS-I Zertifikaten](https://www.levinkeller.de/de/docs/umwelt/co2certificates)
  zu kompensieren würde gerade einmal ca 10.000 Euro kosten. Eine Unsumme von
  25% der Baukosten in diese winzige CO₂-Einsparung durch den Verzicht auf die
  Holzständer zu investieren, ist aus unserer Sicht nicht sinnvoll.

[^1]: Für diesen Gedanken möchte ich mich bei Liam Winckler von DREWES+SPEHT
    bedanken.
