import type * as Preset from "@docusaurus/preset-classic";
import type { Config } from "@docusaurus/types";
import { themes as prismThemes } from "prism-react-renderer";

// This runs in Node.js - Don't use client-side code here (browser APIs, JSX...)

const config: Config = {
	future: {
		experimental_faster: true,
		v4: true,
	},
	title: "Ökohaus Rössing",
	tagline:
		"Berichte und Unterlagen zum Ökohaus der Baufamilie Keller aus Rössing",
	favicon: "img/favicon.ico",

	// Set the production url of your site here
	url: "https://ökohaus.rössing.de/",
	// Set the /<baseUrl>/ pathname under which your site is served
	// For GitHub pages deployment, it is often '/<projectName>/'
	baseUrl: "/",

	// GitHub pages deployment config.
	// If you aren't using GitHub pages, you don't need these.
	organizationName: "levino", // Usually your GitHub org/user name.
	projectName: "oekohaus", // Usually your repo name.

	onBrokenLinks: "throw",
	onBrokenMarkdownLinks: "warn",

	// Even if you don't use internationalization, you can use this field to set
	// useful metadata like html lang. For example, if your site is Chinese, you
	// may want to replace "en" with "zh-Hans".
	i18n: {
		defaultLocale: "de",
		locales: ["de"],
	},

	scripts: [
		{
			src: "https://analytics.levinkeller.de/js/script.js",
			defer: true,
			"data-domain": "ökohaus.rössing.de",
		},
	],

	presets: [
		[
			"classic",
			{
				docs: {
					sidebarPath: "./sidebars.ts",
					routeBasePath: "/",
					path: "./information",
					editUrl: "https://github.com/levino/oekohaus/edit/main/",
				},
				blog: {
					routeBasePath: "/berichte",
					path: "./berichte",
					showReadingTime: true,
					editUrl: "https://github.com/levino/oekohaus/edit/main/",
					feedOptions: {
						type: ["rss", "atom"],
						xslt: true,
					},
					// Useful options to enforce blogging best practices
					onInlineTags: "warn",
					onInlineAuthors: "warn",
					onUntruncatedBlogPosts: "warn",
				},
				theme: {
					customCss: "./src/css/custom.css",
				},
				pages: {
					editUrl: "https://github.com/levino/oekohaus/edit/main/",
				},
			} satisfies Preset.Options,
		],
	],

	themeConfig: {
		// Replace with your project's social card
		image: "img/logo.webp",
		navbar: {
			title: "Ökohaus Rössing",
			logo: {
				alt: "My Site Logo",
				src: "img/logo.webp",
			},
			items: [
				{ to: "/berichte", label: "Berichte", position: "left" },
				{
					label: "Partner",
					position: "left",
					to: "/partners",
				},
				{ to: "/changelog", label: "Changelog", position: "left" },
			],
		},
		footer: {
			style: "dark",
			links: [
				{
					title: "Mehr",
					items: [
						{
							label: "Impressum",
							to: "/imprint",
						},
						{
							label: "Quellcode (ZIP)",
							href: "pathname:///oekohaus-roessing-quellcode.zip",
						},
					],
				},
			],
			copyright: `Copyright © ${new Date().getFullYear()} Levin Keller. Built with Docusaurus.`,
		},
		prism: {
			theme: prismThemes.github,
			darkTheme: prismThemes.dracula,
		},
	} satisfies Preset.ThemeConfig,
};

export default config;
